/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.message;

import com.refinedmods.refinedpipes.blockentity.PipeBlockEntity;
import com.refinedmods.refinedpipes.network.NetworkManager;
import com.refinedmods.refinedpipes.network.pipe.attachment.Attachment;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.BlacklistWhitelist;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.ExtractorAttachment;
import com.refinedmods.refinedpipes.util.DirectionUtil;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ChangeBlacklistWhitelistMessage {
    private final BlockPos pos;
    private final Direction direction;
    private final BlacklistWhitelist blacklistWhitelist;

    public ChangeBlacklistWhitelistMessage(BlockPos pos, Direction direction, BlacklistWhitelist blacklistWhitelist) {
        this.pos = pos;
        this.direction = direction;
        this.blacklistWhitelist = blacklistWhitelist;
    }

    public static void encode(ChangeBlacklistWhitelistMessage message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.writeByte(message.direction.ordinal());
        buf.writeByte(message.blacklistWhitelist.ordinal());
    }

    public static ChangeBlacklistWhitelistMessage decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        Direction direction = DirectionUtil.safeGet(buf.readByte());
        BlacklistWhitelist blacklistWhitelist = BlacklistWhitelist.get(buf.readByte());
        return new ChangeBlacklistWhitelistMessage(pos, direction, blacklistWhitelist);
    }

    public static void handle(ChangeBlacklistWhitelistMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Attachment attachment;
            BlockEntity blockEntity = ((NetworkEvent.Context)ctx.get()).getSender().f_19853_.m_7702_(message.pos);
            if (blockEntity instanceof PipeBlockEntity && (attachment = ((PipeBlockEntity)blockEntity).getAttachmentManager().getAttachment(message.direction)) instanceof ExtractorAttachment) {
                ((ExtractorAttachment)attachment).setBlacklistWhitelist(message.blacklistWhitelist);
                NetworkManager.get(blockEntity.m_58904_()).m_77762_();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

